function test_suite = testTimes %#ok<STOUT>
initTestSuite;

function testZeros %#ok<*DEFNU>
x = polysym(0);
y = polysym(0);
z = x.*y;
assertEqual(z.Value,'0');

function testOneZero
x = polysym(0);
y = polysym('y');
z = x.*y;
assertEqual(z.Value,'0');

function testZeroTimesReal
x = polysym(0);
y = polysym(pi);
z = x.*y;
assertEqual(z.Value,'0');

function testRealTimesChar
x = polysym('x');
y = polysym(5);
z = x.*y;
assertEqual(z.Value,'x*5');

function testScalarTimesVector
x = polysym('x');
y = polysym(1:3);
z = x.*y;
assertEqual(z(1).Value,'x');
assertEqual(z(2).Value,'x*2');
assertEqual(z(3).Value,'x*3');

function testVectorTimesVector
x = polysym({'x','y'});
y = polysym({'u','w'});
z = x.*y;
assertEqual(z(1).Value,'x*u');
assertEqual(z(2).Value,'y*w');

function testTimesTimes
x = polysym('x');
y = polysym('4.*y');
z = x.*y;
assertEqual(z.Value,'x*4.*y');

function testTimesMtimes
x = polysym('x');
y = polysym('4*y');
z = x.*y;
assertEqual(z.Value,'x*4*y');

function testLeftMultiply
x = polysym('x');
z =  (1/2)*x;
assertEqual(z.Value,'0.5*x')

function testRightMultiplyParens
x = polysym('x');
z = x*(1/2);
assertEqual(z.Value,'x*0.5')

function testRightMultiplyNoParens
x = polysym('x');
z = x*1./2;
assertEqual(z.Value,'x/2')
